package ru.yandex.chemodan.app.dataapi.web.generic;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.dataapi.DataApiYtContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.generic.GenericObjectManager;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.web.platform.PlatformGenericAction;
import ru.yandex.chemodan.app.dataapi.web.platform.PlatformProfileBatchAction;
import ru.yandex.chemodan.app.dataapi.web.profile.ProfileBatchGetAction;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.yt.kosher.Yt;

/**
 * @author Denis Bakharev
 */
@Profile("dataapi")
@Configuration
@Import({
        DataApiYtContextConfiguration.class,
})
public class GenericActionsContextConfiguration {
    @Bean
    public PostGenericObjectAction createDataAction(GenericObjectsApiHelper genericObjectsApiHelper) {
        return new PostGenericObjectAction(genericObjectsApiHelper);
    }

    @Bean
    public GetGenericObjectAction getGenericDataAction(GenericObjectsApiHelper genericObjectsApiHelper) {
        return new GetGenericObjectAction(genericObjectsApiHelper);
    }

    @Bean
    public PutGenericObjectAction putGenericObjectAction(GenericObjectsApiHelper genericObjectsApiHelper) {
        return new PutGenericObjectAction(genericObjectsApiHelper);
    }

    @Bean
    public DeleteGenericObjectAction deleteGenericObjectAction(GenericObjectsApiHelper genericObjectsApiHelper) {
        return new DeleteGenericObjectAction(genericObjectsApiHelper);
    }

    @Bean
    public GetListOfGenericObjectsAction getGenericObjectsAction(GenericObjectsApiHelper genericObjectsApiHelper) {
        return new GetListOfGenericObjectsAction(genericObjectsApiHelper);
    }


    @Bean
    public PlatformProfileBatchAction platformProfileBatchAction(ProfileBatchGetAction profileBatchGetAction) {
        return new PlatformProfileBatchAction(profileBatchGetAction);
    }

    @Bean
    public PlatformGenericAction platformGenericAction(ProcessGenericObjectAction processGenericObjectAction) {
        return new PlatformGenericAction(processGenericObjectAction);
    }

    @Bean
    public ProcessGenericObjectAction processGenericObjectAction(
            TypeSettingsRegistry typeSettingsRegistry,
            GenericObjectsApiHelper genericObjectsApiHelper)
    {
        return new ProcessGenericObjectAction(typeSettingsRegistry, genericObjectsApiHelper);
    }

    @Bean
    public ImportGenericObjectsAction importGenericObjectsAction(
            TypeSettingsRegistry typeSettingsRegistry, BazingaTaskManager bazingaTaskManager, Yt yt)
    {
        return new ImportGenericObjectsAction(typeSettingsRegistry, bazingaTaskManager, yt);
    }

    @Bean
    public ImportedObjectsCountersAction importedObjectsCountersAction(Yt yt) {
        return new ImportedObjectsCountersAction(yt);
    }

    @Bean
    public GenericObjectsApiHelper genericObjectsApiHelper(GenericObjectManager genericObjectManager) {
        return new GenericObjectsApiHelper(genericObjectManager);
    }
}
