package ru.yandex.chemodan.app.dataapi.web.generic;

import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;

/**
 * @author Denis Bakharev
 */
@Action(
        value = @Action.Alias(value = "get-generic-object", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить объект")
@Path(value = "/generic_data/{objectId}", methods = HttpMethod.GET)
public class GetGenericObjectAction extends GenericObjectActionBase {

    @PathParam
    private String objectId;

    public GetGenericObjectAction(GenericObjectsApiHelper genericObjectsApiHelper) {
        super(genericObjectsApiHelper);
    }

    @Override
    public Object execute() throws Exception {
        return genericObjectsApiHelper.handleGet(user, objectId, typeName, context);
    }
}
