package ru.yandex.chemodan.app.dataapi.web.generic;

import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author Denis Bakharev
 */
@Action(
        value = @Action.Alias(value = "get-generic-objects", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить объекты")
@Path(value = "/generic_data/", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetListOfGenericObjectsAction extends GenericObjectActionBase {

    public GetListOfGenericObjectsAction(GenericObjectsApiHelper genericObjectsApiHelper) {
        super(genericObjectsApiHelper);
    }

    @Override
    public Object execute() throws Exception {
        return genericObjectsApiHelper.handleGetList(user, typeName, context);
    }
}
