package ru.yandex.chemodan.app.dataapi.web.generic;

import java.util.UUID;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.web.InaccessibleYPathException;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiAppBinder;
import ru.yandex.chemodan.app.dataapi.worker.importer.ImportGenericObjectsTask;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.impl.BazingaIdUtils;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.common.YtErrorMapping;
import ru.yandex.inside.yt.kosher.ytree.YTreeEntityNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author dbrylev
 */
@Action(
        value = @Action.Alias(value = "import-generic-objects", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Заимпортировать объекты из YT")
@Path(value = "/generic_data/import/", methods = HttpMethod.POST)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class ImportGenericObjectsAction extends PublicCloneableActionSupport {

    @BindWith(DataApiAppBinder.class)
    protected Option<String> app;
    @RequestParam
    protected String typeName;
    @RequestParam
    private String ypath;
    @RequestParam
    private Option<String> importId;

    private final TypeSettingsRegistry typeSettingsRegistry;
    private final BazingaTaskManager bazingaTaskManager;
    private final Yt yt;

    public ImportGenericObjectsAction(
            TypeSettingsRegistry typeSettingsRegistry, BazingaTaskManager bazingaTaskManager, Yt yt)
    {
        this.typeSettingsRegistry = typeSettingsRegistry;
        this.bazingaTaskManager = bazingaTaskManager;
        this.yt = yt;
    }

    @Override
    public Object execute() throws Exception {
        validateYPath();

        typeSettingsRegistry.getTypeSettings(typeName);

        String id = importId.getOrElse(() -> UUID.randomUUID().toString());
        BazingaIdUtils.validate(id);

        bazingaTaskManager.schedule(new ImportGenericObjectsTask(typeName, id, ypath));

        return new RawResult(new JsonObject(Cf.map("importId", JsonString.valueOf(id))).serialize());
    }

    private void validateYPath() {
        YPath path;
        try {
            path = YPath.simple(ypath);

        } catch (RuntimeException e) {
            throw new InaccessibleYPathException(ypath, e);
        }

        YTreeNode node;
        try {
            node = yt.cypress().get(path);

        } catch (YtErrorMapping.ResolveError | YtErrorMapping.AuthorizationError e) {
            throw new InaccessibleYPathException(ypath, e);
        }

        if (!(node instanceof YTreeEntityNode)) {
            throw new InaccessibleYPathException(ypath, node.getClass().getSimpleName());
        }
    }
}
