package ru.yandex.chemodan.app.dataapi.web.generic;

import java.util.function.Consumer;

import ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils;
import ru.yandex.chemodan.app.dataapi.worker.importer.readers.generic.ProcessingCounters;
import ru.yandex.chemodan.app.dataapi.worker.importer.readers.generic.ProcessingStats;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.serialize.BenderSerializer;

/**
 * @author dbrylev
 */
@Action(
        value = @Action.Alias(value = "imported-objects-counters", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить счётчики импорта объектов из YT")
@Path(value = "/generic_data/import/{importId}/counters", methods = HttpMethod.GET)
public class ImportedObjectsCountersAction extends PublicCloneableActionSupport {

    private static final BenderSerializer<ProcessingCounters> serializer = Bender.serializer(ProcessingCounters.class);

    @RequestParam
    private String typeName;
    @PathParam
    private String importId;

    private final Yt yt;

    public ImportedObjectsCountersAction(Yt yt) {
        this.yt = yt;
    }

    @Override
    public Object execute() throws Exception {
        YPath path = YtPathsUtils.getImportsResultsYPath(typeName, importId);

        ProcessingCounters counters = new ProcessingCounters();

        if (yt.cypress().exists(path)) {
            yt.tables().read(path, YTableEntryTypes.bender(ProcessingStats.class),
                    (Consumer<ProcessingStats>) s -> counters.plus(s.counters));
        }
        return new RawResult(new String(serializer.serializeJson(counters)));
    }
}
