package ru.yandex.chemodan.app.dataapi.web.generic;

import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author Denis Bakharev
 */
@Action(
        value = @Action.Alias(value = "post-generic-object", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Создать новый объект")
@Path(value = "/generic_data", methods = HttpMethod.POST)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class PostGenericObjectAction extends GenericObjectActionBase {

    public PostGenericObjectAction(GenericObjectsApiHelper genericObjectsApiHelper) {
        super(genericObjectsApiHelper);
    }

    @Override
    public Object execute() {
        return genericObjectsApiHelper.handlePost(user, typeName, context);
    }
}
