package ru.yandex.chemodan.app.dataapi.web.generic;

import lombok.Setter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.generic.MethodNotAllowedException;
import ru.yandex.chemodan.app.dataapi.core.generic.RequiredParamNotSpecifiedException;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettings;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.web.DataApiActionBase;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Denis Bakharev
 */
@Action(value = @Action.Alias(value = "process-generic-object", namespace = ru.yandex.chemodan.util.web.NS.API))
@InterceptWith(ProxyInterceptor.class)
@Path(value = "/process_generic_data/", methods = HttpMethod.POST)
@Setter
public class ProcessGenericObjectAction extends DataApiActionBase {

    private final TypeSettingsRegistry typeSettingsRegistry;
    private final GenericObjectsApiHelper genericObjectsApiHelper;

    public ProcessGenericObjectAction(
            TypeSettingsRegistry typeSettingsRegistry, GenericObjectsApiHelper genericObjectsApiHelper)
    {
        this.typeSettingsRegistry = typeSettingsRegistry;
        this.genericObjectsApiHelper = genericObjectsApiHelper;
    }

    @RequestParam
    private String httpMethod;

    @RequestParam
    private String resourcePath;

    @SpecialParam
    protected ActionInvocationContext context;

    @Override
    public Object execute() throws Exception {
        GenericObjectParams params = getObjectParams();

        switch (httpMethod) {
            case "GET":
                if(params.objId.isPresent()) {
                    return genericObjectsApiHelper.handleGet(user, params.getObjectId(), params.getTypeName(), context);
                }

                return genericObjectsApiHelper.handleGetList(user, params.getTypeName(), context);
            case "POST":
                return genericObjectsApiHelper.handlePost(user, params.getTypeName(), context);
            case "PUT":
                return genericObjectsApiHelper.handlePut(
                        user, params.getObjectId(), params.getTypeName(), context);
            case "DELETE":
                return genericObjectsApiHelper.handleDelete(user, params.getObjectId(), params.getTypeName());
            default:
                throw new MethodNotAllowedException();
        }
    }

    private GenericObjectParams getObjectParams() {
        //Для начала считаем что весь путь это имя типа. Если не нашли такой тип, то отбрасываем все что после
        // последнего слеша и проверяем еще раз
        resourcePath = StringUtils.removeEnd(resourcePath, "/");
        Option<TypeSettings> typeSettingsO = typeSettingsRegistry.getTypeSettingsO(resourcePath);
        if (typeSettingsO.isPresent()) {
            return new GenericObjectParams(Option.empty(), typeSettingsO.get());
        }

        String[] pathParts = resourcePath.split("/");

        String typeName = StringUtils.join(pathParts, "/", 0, pathParts.length - 1);
        TypeSettings ts = typeSettingsRegistry.getTypeSettings(typeName);

        String objectId = pathParts[pathParts.length - 1];
        return new GenericObjectParams(Option.of(objectId), ts);
    }

    private static class GenericObjectParams {
        final Option<String> objId;
        final TypeSettings typeSettings;

        GenericObjectParams(Option<String> objId, TypeSettings typeSettings) {
            this.objId = objId;
            this.typeSettings = typeSettings;
        }

        String getObjectId() {
            if (!objId.isPresent()) {
                throw new RequiredParamNotSpecifiedException("object id");
            }
            return objId.get();
        }

        String getTypeName() {
            return typeSettings.typeName;
        }
    }
}
