package ru.yandex.chemodan.app.dataapi.web.generic;

import java.io.OutputStream;

import ru.yandex.chemodan.app.dataapi.web.direct.DirectActionInvocationUtils;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.SelfSerializer;
import ru.yandex.commune.a3.action.result.Variant;
import ru.yandex.commune.a3.action.result.Variants;
import ru.yandex.commune.a3.action.result.json.JsonWriterUtils;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.commune.json.write.JsonWriter;
import ru.yandex.commune.json.write.JsonWriterFactory;

/**
 * @author Denis Bakharev
 */
public class RawResult extends SelfSerializer<RawResult> {
    public final String result;

    public RawResult(String result) {
        this.result = result;
    }

    @Override
    protected void serialize(Variant variant, ActionInvocationContext context, OutputStream stream) {
        JsonWriter jw = JsonWriterFactory.defaultFactory().createJsonWriter(stream);

        if (DirectActionInvocationUtils.isDirectInvocation(context)) {
            jw.writeRawValue(result);
        } else {
            jw.writeObjectStart();

            jw.writeObjectFieldStart("invocationInfo");
            JsonWriterUtils.writeAdditionalAttrs(jw, context.getAdditionalAttrs());
            jw.writeObjectEnd();
            jw.writeFieldName("result");
            jw.writeRawValue(result);

            jw.writeObjectEnd();
        }
        jw.flush();
    }

    @Override
    protected Variants getVariants() {
        return Variants.cons(MediaType.APPLICATION_JSON);
    }
}
