package ru.yandex.chemodan.app.dataapi.web.internal;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.DatabaseAction;
import ru.yandex.chemodan.app.dataapi.web.DeltaParameterBinder;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.misc.db.masterSlave.MasterSlaveContextHolder;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "put-delta-nocheck", namespace = NS.INTERNAL),
        description = "Применить дельту без проверки ревизии")
@Path(value = "/databases/{databaseId}/diffs/nocheck", methods = HttpMethod.PUT)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class ApplyDeltaToCurrentRevision extends DatabaseAction {

    @BindWith(DeltaParameterBinder.class)
    private Delta delta;

    public ApplyDeltaToCurrentRevision(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public OkPojo execute() throws Exception {
        Database database = MasterSlaveContextHolder.withPolicy(MasterSlavePolicy.R_SM,
                () -> dataApiManager.getDatabase(databaseSpec())
        );

        dataApiManager.applyDelta(databaseSpec(), database.rev, RevisionCheckMode.PER_RECORD, delta);
        return new OkPojo();
    }
}
