package ru.yandex.chemodan.app.dataapi.web.internal;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
         value = @Action.Alias(value = "delete-record", namespace = NS.INTERNAL),
         description = "Удалить один объект")
@Path(value = "/databases/{databaseId}/table/{collectionId}/row/{recordId}", methods = HttpMethod.DELETE)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class DeleteRecordAction extends OneRecordAction {

    protected DeleteRecordAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public Object execute() {
        Database database = dataApiManager.getDatabase(databaseSpec());
        Delta delta = new Delta(Cf.list(RecordChange.delete(collectionRef(), recordId)));
        dataApiManager.applyDelta(databaseSpec(), database.rev, RevisionCheckMode.PER_RECORD, delta);
        return new OkPojo();
    }
}
