package ru.yandex.chemodan.app.dataapi.web.internal;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "delete-field", namespace = NS.INTERNAL),
        description = "Удалить одно поле из объекта")
@Path(value = "/databases/{databaseId}/collection/{collectionId}/record/{recordId}/{key}", methods = HttpMethod.DELETE)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class DeleteRecordFieldAction extends OneRecordAction {

    @PathParam
    private String key;

    protected DeleteRecordFieldAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public Object execute() {
        Database database = dataApiManager.getDatabase(databaseSpec());
        Delta delta = new Delta(RecordChange.update(collectionRef(), recordId,
                FieldChange.delete((key))));
        dataApiManager.applyDelta(databaseSpec(), database.rev, RevisionCheckMode.PER_RECORD, delta);
        return new OkPojo();
    }
}
