package ru.yandex.chemodan.app.dataapi.web.internal;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "get-record", namespace = NS.INTERNAL),
        description = "Прочитать один объект из базы")
@Path(value = "/databases/{databaseId}/collection/{collectionId}/record/{recordId}", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetRecordAction extends OneRecordAction {

    protected GetRecordAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public SnapshotPojoRow execute() {
        return dataApiManager.getSnapshotRow(user, refRecordId());
    }
}
