package ru.yandex.chemodan.app.dataapi.web.internal;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author tolmalev
 */
@Configuration
public class InternalActionsContextConfiguration {

    @Bean
    public GetRecordAction getRecordAction(DataApiManager dataApiManager) {
        return new GetRecordAction(dataApiManager);
    }

    @Bean
    public PutRecordFieldAction putRecordFieldAction(DataApiManager dataApiManager) {
        return new PutRecordFieldAction(dataApiManager);
    }

    @Bean
    public PutRecordAction putRecordAction(DataApiManager dataApiManager) {
        return new PutRecordAction(dataApiManager);
    }

    @Bean
    public DeleteRecordFieldAction deleteRecordFieldAction(DataApiManager dataApiManager) {
        return new DeleteRecordFieldAction(dataApiManager);
    }

    @Bean
    public DeleteRecordAction deleteRecordAction(DataApiManager dataApiManager) {
        return new DeleteRecordAction(dataApiManager);
    }

    @Bean
    public ApplyDeltaToCurrentRevision applyDeltaToCurrentRevision(DataApiManager dataApiManager) {
        return new ApplyDeltaToCurrentRevision(dataApiManager);
    }

    @Bean
    public OnDatabaseUpdateAction OnDatabaseUpdateAction(DataApiManager dataApiManager) {
        return new OnDatabaseUpdateAction(dataApiManager);
    }
}
