package ru.yandex.chemodan.app.dataapi.web.internal;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.DatabaseAction;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Action(
        value = @Action.Alias(value = "on-update", namespace = NS.INTERNAL),
        description = "Уведомить об измененеии базы данных внешнего источника")
@Path(value = "/databases/{databaseId}/on-change", methods = HttpMethod.PUT)
public class OnDatabaseUpdateAction extends DatabaseAction {
    @RequestParam
    private long rev;

    protected OnDatabaseUpdateAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public Object execute() throws Exception {
        dataApiManager.onDatabaseUpdate(databaseSpec(), rev);
        return new OkPojo();
    }
}
