package ru.yandex.chemodan.app.dataapi.web.internal;

import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordRef;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.DatabaseAction;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;

/**
 * @author tolmalev
 */
abstract class OneRecordAction extends DatabaseAction {

    @PathParam
    protected String recordId;
    @PathParam
    protected String collectionId;

    OneRecordAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    CollectionRef collectionRef() {
        return databaseRef().consColRef(collectionId);
    }

    RecordRef refRecordId() {
        return collectionRef().consRecordRef(recordId);
    }
}
