package ru.yandex.chemodan.app.dataapi.web.internal;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.SimpleDataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "put-record", namespace = NS.INTERNAL),
        description = "Создать объект")
@Path(value = "/databases/{databaseId}/collection/{collectionId}/record/{recordId}", methods = HttpMethod.PUT)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class PutRecordAction extends OneRecordAction {

    @BindWith(value = BenderJsonParameterBinder.class)
    private PutRequest putRequest;

    protected PutRecordAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public Object execute() {
        Database database = dataApiManager.getDatabase(databaseSpec());
        Delta delta = new SimpleDataRecord(refRecordId(), putRequest.data)
                .toSetChange()
                .toDelta();
        dataApiManager.applyDelta(databaseSpec(), database.rev, RevisionCheckMode.PER_RECORD, delta);
        return new OkPojo();
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    private static final class PutRequest {
        public final MapF<String, DataField> data;

        private PutRequest(MapF<String, DataField> data) {
            this.data = data;
        }
    }
}
