package ru.yandex.chemodan.app.dataapi.web.internal;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldType;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "put-field", namespace = NS.INTERNAL),
        description = "Изменить поле объекта")
@Path(value = "/databases/{databaseId}/collection/{collectionId}/record/{recordId}/{key}", methods = HttpMethod.PUT)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class PutRecordFieldAction extends OneRecordAction {

    @PathParam
    private String key;
    @RequestParam
    private DataFieldType type;
    @RequestParam
    private String value;

    protected PutRecordFieldAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public Object execute() {
        Database database = dataApiManager.getDatabase(databaseSpec());
        Delta delta = new Delta(RecordChange.update(
                collectionRef(),
                recordId,
                FieldChange.put(key, DataField.cons(type, value))
        ));
        dataApiManager.applyDelta(databaseSpec(), database.rev, RevisionCheckMode.PER_RECORD, delta);
        return new OkPojo();
    }
}
