package ru.yandex.chemodan.app.dataapi.web.platform;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.auth.FromAttributeInterceptor;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchAllAction;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchRequest;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchRequestItem;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchResult;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchSupport;
import ru.yandex.chemodan.app.dataapi.web.batch.OneInvocationJsonResult;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiOptionUserIdBinder;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyBatchInterceptor;
import ru.yandex.chemodan.util.web.interceptors.WithThreadLocalCache;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.misc.net.uri.Uri2;

@Action(
        value = @Action.Alias(value = "get-batch-platform", namespace = NS.ROOT),
        description = "Выполнить batch запрос для получения данных")
@Path(value = "/platform/batch", methods = {HttpMethod.POST})
@WithThreadLocalCache
@InterceptWith({ProxyBatchInterceptor.class})
public class PlatformBatchAction extends BatchAllAction {

    @BindWith(DataApiOptionUserIdBinder.class)
    protected Option<DataApiUserId> user;

    public PlatformBatchAction(BatchSupport batchSupport) {
        super(batchSupport);
    }

    @Override
    public PlatformBatchResult execute() throws Exception {
        user.ifPresent(u -> context.getRequest().getHttpServletRequest().setAttribute(FromAttributeInterceptor.ATTR_KEY, u));
        ListF<BatchRequestItem> items = batchRequest.getItems();
        ListF<BatchRequestItem> platform = items
                .map(i -> new BatchRequestItem(i.headers, i.method, normalizeUrl(i.relativeUrl), i.body));
        BatchResult execute = super.execute(new BatchRequest(platform));
        List<OneInvocationJsonResult> invocationResults = execute.getInvocationResults();
        List<PlatformInvocationResult> collect =
                invocationResults.stream().map(p -> new PlatformInvocationResult(p.statusCode, p.result)).collect(Collectors.toList());
        return new PlatformBatchResult(collect);
    }

    static String normalizeUrl(String url) {
        Uri2 parse = Uri2.parse(url);
        String path = parse.getPath()
                .replace("/v1", "/platform/platform")
                .replace("/v2", "/platform/platform/v2");
        if (parse.getQuery().isPresent()) {
            return path + "?" + parse.getQuery().get();
        }
        return path;
    }

}
