package ru.yandex.chemodan.app.dataapi.web.platform;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

public class PlatformBatchActionTest {

    @Test
    public void testCutV1Url() {
        String s = "http://dataapi-load01g.dst.yandex.net:21859/v1/personality/profile/tv_test/programs/481180";
        assertEquals(PlatformBatchAction.normalizeUrl(s), "/platform/platform/personality/profile/tv_test/programs/481180");

        s = "/v1/personality/profile/tv_test/programs/481180";
        assertEquals(PlatformBatchAction.normalizeUrl(s), "/platform/platform/personality/profile/tv_test/programs/481180");

        s = "/v1/personality/profile/tv_test/programs/481180?key=value&bla=bla1";
        assertEquals(PlatformBatchAction.normalizeUrl(s), "/platform/platform/personality/profile/tv_test/programs/481180?key=value&bla=bla1");
    }

    @Test
    public void testCutV2Url() {
        String s = "http://dataapi-load01g.dst.yandex.net:21859/v2/personality/profile/tv_test/programs/481180";
        assertEquals(PlatformBatchAction.normalizeUrl(s), "/platform/platform/v2/personality/profile/tv_test/programs/481180");

        s = "/v2/personality/profile/tv_test/programs/481180";
        assertEquals(PlatformBatchAction.normalizeUrl(s), "/platform/platform/v2/personality/profile/tv_test/programs/481180");

        s = "/v2/personality/profile/tv_test/programs/481180?key=value&bla=bla1";
        assertEquals(PlatformBatchAction.normalizeUrl(s), "/platform/platform/v2/personality/profile/tv_test/programs/481180?key=value&bla=bla1");
    }
}
