package ru.yandex.chemodan.app.dataapi.web.platform;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.a3.action.result.json.JsonWriterActionResult;
import ru.yandex.commune.a3.action.result.xml.RootElementSource;
import ru.yandex.commune.json.write.JsonWriter;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@AllArgsConstructor
@Bendable
@BenderBindAllFields
public class PlatformBatchResult implements JsonWriterActionResult, RootElementSource {
    public final List<PlatformInvocationResult> items;

    @Override
    public String getRootElement() {
        return "items";
    }

    @Override
    public void write(JsonWriter jw, Tuple2List<String, Object> additionalAttributes) {
        jw.writeObjectStart();
        jw.writeFieldName(getRootElement());
        jw.writeArrayStart();
        for (PlatformInvocationResult invocationResult : items) {
            jw.writeObjectStart();
            writeChildNodeIfExist(invocationResult.body, jw);
            jw.writeNumberField("code", invocationResult.code);
            jw.writeObjectEnd();
        }
        jw.writeArrayEnd();
    }

    private void writeChildNodeIfExist(JsonNode rootNode, JsonWriter jw) {
        if (rootNode == null) {
            return;
        }
        JsonNode result = rootNode.get("result");
        JsonNode error = rootNode.get("error");

        if(result == null && error == null) {
            jw.writeStringField("body", rootNode.toString());
        } else if (result != null) {
            jw.writeStringField("body", result.toString());
        } else if (error != null) {
            JsonNode errorName = error.get("name");
            JsonNode message = error.get("message");
            jw.writeStringField("body", error.toString());
            if (errorName != null) {
                jw.writeStringField("error", errorName.toString());
                jw.writeStringField("message", message.toString());
            }
        }
    }
}
