package ru.yandex.chemodan.app.dataapi.web.platform;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiAppBinder;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiUserIdBinder;
import ru.yandex.chemodan.app.dataapi.web.generic.ProcessGenericObjectAction;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.interceptors.WithThreadLocalCache;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.lang.ObjectUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

@Action(
        value = @Action.Alias(value = "get-batch-platform", namespace = NS.ROOT),
        description = "Выполнить platform generic запрос для получения данных")
@Path(value = "/platform/personality/profile/{ext:.*}",
        methods = {HttpMethod.POST, HttpMethod.PUT, HttpMethod.GET, HttpMethod.DELETE})
@WithThreadLocalCache
@InterceptWith(ProxyInterceptor.class)
@RequiredArgsConstructor
public class PlatformGenericAction extends PublicCloneableActionSupport {

    private final ProcessGenericObjectAction processGenericObjectAction;
    @BindWith(DataApiUserIdBinder.class)
    protected DataApiUserId user;
    @PathParam
    protected String ext;
    @BindWith(DataApiAppBinder.class)
    protected Option<String> app;
    @PathParam(value = "context")
    protected Option<String> restLikeContextStr;
    @RequestParam(value = "context")
    protected Option<String> restLikeContextStrGetParam;
    @SpecialParam
    protected ActionInvocationContext context;
    @SpecialParam
    private HttpServletRequestX req;

    @Override
    public Object execute() throws Exception {
        ProcessGenericObjectAction action = ObjectUtils.clone(processGenericObjectAction);
        String method = req.getMethod().toUpperCase();
        action.setContext(context);
        action.setHttpMethod(method.toUpperCase());
        action.setResourcePath(ext);
        action.setUser(user);
        action.setApp(app);
        action.setRestLikeContextStr(restLikeContextStr);
        action.setRestLikeContextStrGetParam(restLikeContextStrGetParam);
        return action.execute();
    }

}
