package ru.yandex.chemodan.app.dataapi.web.platform;

import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.Address;
import ru.yandex.chemodan.app.dataapi.apps.profile.geopoint.GeoPoint;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

@ActionResultPojo
@Bendable
@Builder
@Data
public class PlatformGeoPoint {

    @BenderPart(name = "data_key", strictName = true)
    @Builder.Default private final Option<String> dataKey = Option.empty();
    @BenderPart
    @Builder.Default private final Option<String> title = Option.empty();
    @BenderPart
    @Builder.Default private final ListF<String> tags = Cf.arrayList();
    @BenderPart
    private final double latitude;
    @BenderPart
    private final double longitude;
    @BenderPart(name = "address_line", strictName = true)
    @Builder.Default private final Option<String> addressLine = Option.empty();
    @BenderPart(name = "address_line_short", strictName = true)
    @Builder.Default private final Option<String> addressLineShort = Option.empty();

    public static PlatformGeoPoint fromAddress(Address a) {
        return PlatformGeoPoint.builder()
                .title(Option.ofNullable(a.getTitle()))
                .tags(a.getTags())
                .longitude(a.getLongitude())
                .latitude(a.getLatitude())
                .addressLine(a.getAddressLine())
                .addressLineShort(a.getAddressLineShort())
                .dataKey(a.getAddressId())
                .build();
    }

    public static PlatformGeoPoint fromAddress(GeoPoint p) {
        return PlatformGeoPoint.builder()
                .title(p.getTitle())
                .tags(p.getTags())
                .longitude(p.getLongitude())
                .latitude(p.getLatitude())
                .dataKey(p.getGeoPointId())
                .build();
    }
}
