package ru.yandex.chemodan.app.dataapi.web.platform;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@Action(
        value = @Action.Alias(value = "get-address", namespace = NS.ROOT),
        description = "Получить один адрес пользователя")
@Path("/platform/v2/personality/profile/addresses/{addressId}")
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class PlatformGetAddressAction extends GetProfilePartActionSupport<PlatformGeoPoint> {

    public PlatformGetAddressAction(CachedFullProfileManager profileManager) {
        super(profileManager, true);
    }

    @PathParam
    private String addressId;

    @Override
    public PlatformGeoPoint getFromFullProfile(FullUserProfile profile) {
        return PlatformGeoPoint.fromAddress(profile.addresses.addresses
                .filter(address -> address.getAddressId().isSome(addressId))
                .firstO()
                .getOrThrow(NotFoundException.consF("Address not found: " + addressId)));
    }
}
