package ru.yandex.chemodan.app.dataapi.web.platform;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@Action(
        value = @Action.Alias(value = "v2-get-addresses", namespace = NS.ROOT),
        description = "Получить все адреса пользователя")
@Path("/platform/v2/personality/profile/addresses")
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class PlatformGetAddressesAction extends GetProfilePartActionSupport<PlatformProfileBatch> {

    public PlatformGetAddressesAction(CachedFullProfileManager profileManager) {
        super(profileManager, true);
    }

    @Override
    public PlatformProfileBatch getFromFullProfile(FullUserProfile profile) {
        return new PlatformProfileBatch(
                profile.addresses.addresses.map(PlatformGeoPoint::fromAddress).take(100),
                100,
                0
        );
    }
}
