package ru.yandex.chemodan.app.dataapi.web.platform;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.commune.a3.action.result.json.JsonWriterActionResult;
import ru.yandex.commune.json.write.BenderJsonWriterWrapper;
import ru.yandex.commune.json.write.JsonWriter;
import ru.yandex.misc.bender.BenderMapper;

@Data
@AllArgsConstructor
public class PlatformProfileBatch implements JsonWriterActionResult {

    private final static BenderMapper benderMapper = DataApiBenderUtils.mapper();

    private final ListF<PlatformGeoPoint> items;
    private final int limit;
    private final int offset;

    @Override
    public void write(JsonWriter jw, Tuple2List<String, Object> additionalAttributes) {
        jw.writeObjectStart();
        jw.writeFieldName("items");
        jw.writeArrayStart();
        items.stream().skip(offset).limit(limit).forEach(r -> benderMapper.serializeJson(r, new BenderJsonWriterWrapper(jw)));
        jw.writeArrayEnd();
        jw.writeFieldName("limit");
        jw.writeNumber(limit);
        jw.writeFieldName("total");
        jw.writeNumber(items.size());
        jw.writeFieldName("offset");
        jw.writeNumber(offset);
    }
}
