package ru.yandex.chemodan.app.dataapi.web.platform;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiAppBinder;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiUserIdBinder;
import ru.yandex.chemodan.app.dataapi.web.profile.ProfileBatchGetAction;
import ru.yandex.chemodan.app.dataapi.web.profile.addresses.GetAddressesAction;
import ru.yandex.chemodan.app.dataapi.web.profile.geopoint.GetGeoPointsAction;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.lang.ObjectUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

@RequiredArgsConstructor
@Action(
        value = @Action.Alias(value = "get-batch-platform", namespace = NS.ROOT),
        description = "Выполнить platform profile batch запрос")
@Path(value = "/platform/personality/profile/addresses/{ext:.*}",
        methods = {HttpMethod.GET, HttpMethod.DELETE})
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class PlatformProfileBatchAction extends PublicCloneableActionSupport {

    private final ProfileBatchGetAction profileBatchGetAction;
    @BindWith(DataApiUserIdBinder.class)
    protected DataApiUserId user;
    @PathParam
    protected String ext;
    @RequestParam
    private Option<Integer> limit;
    @RequestParam
    private Option<Integer> offset;
    @BindWith(DataApiAppBinder.class)
    protected Option<String> app;
    @PathParam(value = "context")
    protected Option<String> restLikeContextStr;
    @RequestParam(value = "context")
    protected Option<String> restLikeContextStrGetParam;
    @SpecialParam
    protected ActionInvocationContext context;
    @SpecialParam
    private HttpServletRequestX req;
    @SpecialParam
    private HttpServletResponseX resp;

    @Override
    public Object execute() throws Exception {
        ProfileBatchGetAction action = ObjectUtils.clone(profileBatchGetAction);
        action.setApp(app);
        action.setRestLikeContextStr(restLikeContextStr);
        action.setUser(user);
        action.setRestLikeContextStrGetParam(restLikeContextStrGetParam);
        action.setQueries(Cf.list("addresses", "geopoints"));
        action.setReq(req);
        action.setResp(resp);
        ListF<ProfileBatchGetAction.ResultWithStatusCode> resultWithStatusCodes =
                action.executeInner();
        return new PlatformProfileBatch(
                process(resultWithStatusCodes),
                limit.getOrElse(20), //Simulate rest behaviour
                offset.getOrElse(0)
        );
    }

    private ListF<PlatformGeoPoint> process(ListF<ProfileBatchGetAction.ResultWithStatusCode> resultWithStatusCodes) {
        ListF<PlatformGeoPoint> geoPoints = Cf.arrayList();
        resultWithStatusCodes.stream().filter(res -> res.result != null).map(res -> res.result)
                .forEach(
                        res -> {
                            if (res instanceof GetGeoPointsAction.ListGeoPointPojo) {
                                ((GetGeoPointsAction.ListGeoPointPojo) res).items
                                        .forEach(p -> geoPoints.add(PlatformGeoPoint.fromAddress(p)));
                            } else if (res instanceof GetAddressesAction.ListAddressesPojo) {
                                ((GetAddressesAction.ListAddressesPojo) res).items
                                        .forEach(p -> geoPoints.add(PlatformGeoPoint.fromAddress(p)));
                            }
                        });
        return geoPoints;
    }

}
