package ru.yandex.chemodan.app.dataapi.web.platform;

import lombok.Builder;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.Address;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.app.dataapi.web.profile.addresses.AddressActionBase;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@Action(
        value = @Action.Alias(value = "platform-set-address", namespace = NS.ROOT),
        description = "Изменить адрес")
@Path(value = "/platform/personality/profile/addresses/", methods = {HttpMethod.PUT, HttpMethod.POST})
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class PlatformSetAddressAction extends AddressActionBase {

    //TODO: remove it
    @Bendable
    @Data
    public static class PlatformSetPoint {

        @BenderPart(name = "data_key", strictName = true)
        private final String dataKey;
        @BenderPart
        private final String title;
        @BenderPart
        private final double latitude;
        @BenderPart
        private final Option<String> tags;
        @BenderPart
        private final double longitude;
        @BenderPart(name = "address_line", strictName = true)
        private final Option<String> addressLine;
        @BenderPart(name = "address_line_short", strictName = true)
        private final Option<String> addressLineShort;
    }

    @ActionResultPojo
    @Bendable
    @Builder
    @Data
    public static class PlatformSetPointResponse {

        @BenderPart
        private final String href;
        @BenderPart
        private final String method = "GET";
        @BenderPart
        private final boolean templated = false;
    }

    @Value("${platform.personality.addresses.baseurl}")
    private String baseUrl;

    @BindWith(value = BenderJsonParameterBinder.class)
    private PlatformSetPoint platformSetPoint;

    public PlatformSetAddressAction(AddressManager addressesManager) {
        super(addressesManager);
    }

    @Override
    public PlatformSetPointResponse execute() throws Exception {
        String id = platformSetPoint.getDataKey();
        Address address = new Address(id);
        address.setAddressLine(platformSetPoint.getAddressLine());
        address.setAddressLineShort(platformSetPoint.getAddressLineShort());
        address.setTitle(platformSetPoint.getTitle());
        address.setLatitude(platformSetPoint.getLatitude());
        address.setLongitude(platformSetPoint.getLongitude());
        address.setTags(platformSetPoint.getTags());
        Address a = addressManager.putAddressIgnoringMinedAttributes(user, address);
        return PlatformSetPointResponse.builder().href(baseUrl + a.getAddressId().get()).build();
    }
}
