package ru.yandex.chemodan.app.dataapi.web.pojo;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextSource;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseMeta;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.dataSize.DataSize;

/**
* @author tolmalev
*/
@ActionResultPojo
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
@ProtoMessage
public class DatabasePojo {
    @ProtoField(n = 1)
    public final long rev;
    @BenderPart(name = "count")
    @ProtoField(n = 2)
    public final long recordsCount;

    @BenderPart(name = "created")
    @ProtoField(n = 3)
    public final Instant creationTime;
    @BenderPart(name = "modified")
    @ProtoField(n = 4)
    public final Instant modificationTime;
    @ProtoField(n = 5)
    public final long size;
    @ProtoField(n = 6)
    public final String databaseId;

    @ProtoField(n = 7)
    public final Option<String> description;

    @ProtoField(n = 9)
    public final String handle;

    public DatabasePojo(Database database) {
        rev = database.rev;
        databaseId = database.aliasId();

        recordsCount = database.meta.recordsCount;
        creationTime = database.meta.creationTime;
        modificationTime = database.meta.modificationTime;
        size = database.meta.size.toBytes();
        description = database.meta.description;
        handle = database.handleValue();
    }

    public DatabasePojo(long rev, long recordsCount, Instant creationTime, Instant modificationTime, long size,
            String databaseId, Option<String> description, String handle) {
        this.rev = rev;
        this.recordsCount = recordsCount;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.size = size;
        this.databaseId = databaseId;
        this.description = description;
        this.handle = handle;
    }

    public Database toNewDatabase(DataApiUserId uid, DatabaseContextSource contextSource) {
        return toNewDatabase(uid, contextSource.dbContext());
    }

    private Database toNewDatabase(DataApiUserId uid, DatabaseContext context) {
        return Database.consNew(uid, consHandle(context), rev, consMeta());
    }

    public Database toExistingDatabase(DataApiUserId uid, DatabaseContextSource contextSource) {
        return toExistingDatabase(uid, contextSource.dbContext());
    }

    private Database toExistingDatabase(DataApiUserId uid, DatabaseContext context) {
        return new Database(uid, consHandle(context), rev, consMeta());
    }

    private DatabaseHandle consHandle(DatabaseContext context) {
        return context.consDbRef(databaseId)
                .consHandle(handle);
    }

    public DatabaseMeta consMeta() {
        return new DatabaseMeta(creationTime, modificationTime, new DataSize(size), recordsCount);
    }
}
