package ru.yandex.chemodan.app.dataapi.web.pojo;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoIgnoreField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
* @author tolmalev
*/
@ActionResultPojo
@Bendable
@ProtoMessage
public class ListDatabasesPojo {
    @BenderPart
    @ProtoField(n = 1)
    public final ListF<DatabasePojo> databases;

    @ProtoIgnoreField
    public final int total;
    @ProtoIgnoreField
    public final int limit;
    @ProtoIgnoreField
    public final int offset;

    public ListDatabasesPojo(ListF<Database> databases, int total, int limit, int offset) {
        this.databases = databases.map(DatabasePojo::new);
        this.total = total;
        this.limit = limit;
        this.offset = offset;
    }
}
