package ru.yandex.chemodan.app.dataapi.web.pojo;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojo;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@ActionResultPojo
@BenderBindAllFields
@ProtoMessage
public class TakeoutPojo {

    @ProtoField(n = 1)
    public final String status;

    @ProtoField(n = 2)
    public final MapF<String, String> data;

    public TakeoutPojo(ListF<Snapshot> snapshots) {
        if (snapshots.isEmpty()) {
            status = "no_data";
        } else {
            status = "ok";
        }
        data = Cf.hashMapWithExpectedSize(snapshots.size());
        for (Snapshot snapshot : snapshots) {
            final String filename = snapshot.database.alias.toString() + ".json";
            final SnapshotPojo snapshotPojo = snapshot.toPojo();
            final byte[] snapshotByteArray = DataApiBenderUtils.mapper().serializeJson(snapshotPojo);
            data.put(filename, new String(snapshotByteArray));
        }
    }
}
