package ru.yandex.chemodan.app.dataapi.web.profile;

import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.web.DataApiActionBase;
import ru.yandex.misc.db.masterSlave.MasterSlaveContextHolder;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;

/**
 * @author tolmalev
 */
public abstract class GetProfilePartActionSupport<Result> extends DataApiActionBase {

    protected final CachedFullProfileManager profileManager;
    protected final boolean retryOnError;

    public GetProfilePartActionSupport(CachedFullProfileManager profileManager) {
        this(profileManager, false);
    }

    public GetProfilePartActionSupport(CachedFullProfileManager profileManager, boolean retryOnError) {
        this.profileManager = profileManager;
        this.retryOnError = retryOnError;
    }

    @Override
    public Result execute() throws Exception {
        try {
            return getFromFullProfile(profileManager.getProfile(user));
        } catch (RuntimeException e) {
            if (retryOnError) {
                return MasterSlaveContextHolder.withPolicy(
                        MasterSlavePolicy.R_M, () -> getFromFullProfile(profileManager.getProfileNoCache(user)));
            } else {
                throw e;
            }
        }
    }

    public abstract Result getFromFullProfile(FullUserProfile profile);
}
