package ru.yandex.chemodan.app.dataapi.web.profile;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.web.profile.addresses.ProfileAddressesActionsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.web.profile.events.EventsActionsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.web.profile.geopoint.ProfileGeoPointActionsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.web.profile.yatickets.orders.OrdersActionsContextConfiguration;

/**
 * @author tolmalev
 */
@Profile("dataapi")
@Configuration
@Import({
        ProfileAddressesActionsContextConfiguration.class,
        EventsActionsContextConfiguration.class,
        OrdersActionsContextConfiguration.class,
        ProfileGeoPointActionsContextConfiguration.class
})
public class ProfileActionsContextConfiguration {

    @Bean
    public ProfileBatchGetAction profileBatchGetAction(CachedFullProfileManager profileManager) {
        return new ProfileBatchGetAction(profileManager);
    }
}
