package ru.yandex.chemodan.app.dataapi.web.profile.addresses;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.Address;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "post-address", namespace = NS.PROFILE),
        description = "Создать адрес")
@Path(value = "/addresses", methods = HttpMethod.POST)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class CreateAddressAction extends AddressActionBase {

    @BindWith(value = BenderJsonParameterBinder.class)
    private Address rawAddress;

    public CreateAddressAction(AddressManager addressesManager) {
        super(addressesManager);
    }

    @Override
    public Address execute() throws Exception {
        return addressManager.createAddress(user, rawAddress);
    }
}
