package ru.yandex.chemodan.app.dataapi.web.profile.addresses;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "delete-address", namespace = NS.PROFILE),
        description = "Удалить адрес пользователя")
@Path(value = "/addresses/{addressId}", methods = HttpMethod.DELETE)
@Path(value = "/platform/v2/personality/profile/addresses/{addressId}", methods = HttpMethod.DELETE)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class DeleteAddressAction extends AddressActionBase {

    @PathParam
    private String addressId;

    public DeleteAddressAction(AddressManager addressesManager) {
        super(addressesManager);
    }

    @Override
    public OkPojo execute() throws Exception {
        addressManager.deleteAddress(user, addressId);
        return new OkPojo();
    }
}
