package ru.yandex.chemodan.app.dataapi.web.profile.addresses;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.Address;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "get-address", namespace = NS.PROFILE),
        description = "Получить один адрес пользователя")
@Path("/addresses/{addressId}")
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetAddressAction extends GetProfilePartActionSupport<Address> {

    @PathParam
    private String addressId;

    public GetAddressAction(CachedFullProfileManager profileManager) {
        super(profileManager, true);
    }

    @Override
    public Address getFromFullProfile(FullUserProfile profile) {
        return profile.addresses.addresses
                .filter(address -> address.getAddressId().isSome(addressId))
                .firstO()
                .getOrThrow(NotFoundException.consF("Address not found: " + addressId));
    }
}
