package ru.yandex.chemodan.app.dataapi.web.profile.addresses;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.Address;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "get-addresses", namespace = NS.PROFILE),
        description = "Получить список адресов пользователя")
@Path("/addresses")
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetAddressesAction extends GetProfilePartActionSupport<GetAddressesAction.ListAddressesPojo> {
    public GetAddressesAction(CachedFullProfileManager profileManager) {
        super(profileManager);
    }

    @Override
    public ListAddressesPojo getFromFullProfile(FullUserProfile profile) {
        return new ListAddressesPojo(profile.addresses.addresses);
    }

    @BenderBindAllFields
    @ActionResultPojo
    public static final class ListAddressesPojo {
        public final ListF<Address> items;

        private ListAddressesPojo(ListF<Address> items) {
            this.items = items;
        }
    }
}
