package ru.yandex.chemodan.app.dataapi.web.profile.addresses;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressPatch;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "patch-address", namespace = NS.PROFILE),
        description = "Частично изменить адрес")
@Path(value = "/addresses/{addressId}", methods = HttpMethod.PATCH)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class PatchAddressAction extends AddressActionBase {
    @PathParam
    private String addressId;
    @BindWith(value = BenderJsonParameterBinder.class)
    private AddressPatch patch;

    public PatchAddressAction(AddressManager profileManager) {
        super(profileManager);
    }

    @Override
    public OkPojo execute() throws Exception {
        addressManager.patchAddress(user, addressId, patch);
        return new OkPojo();
    }
}
