package ru.yandex.chemodan.app.dataapi.web.profile.addresses;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.web.platform.PlatformGetAddressAction;
import ru.yandex.chemodan.app.dataapi.web.platform.PlatformGetAddressesAction;
import ru.yandex.chemodan.app.dataapi.web.platform.PlatformSetAddressAction;

/**
 * @author tolmalev
 */
@Configuration
public class ProfileAddressesActionsContextConfiguration {
    @Bean
    public GetAddressesAction getAddressesAction(CachedFullProfileManager profileManager) {
        return new GetAddressesAction(profileManager);
    }

    @Bean
    public GetAddressAction getAddressAction(CachedFullProfileManager profileManager) {
        return new GetAddressAction(profileManager);
    }

    @Bean
    public PlatformGetAddressAction platformGetAddressAction(CachedFullProfileManager profileManager) {
        return new PlatformGetAddressAction(profileManager);
    }

    @Bean
    public PlatformGetAddressesAction platformGetAddresses(CachedFullProfileManager profileManager) {
        return new PlatformGetAddressesAction(profileManager);
    }

    @Bean
    public CreateAddressAction createAddressAction(AddressManager addressesManager) {
        return new CreateAddressAction(addressesManager);
    }

    @Bean
    public SetAddressAction changeAddressAction(AddressManager addressesManager) {
        return new SetAddressAction(addressesManager);
    }

    @Bean
    public PlatformSetAddressAction platformSetAddressAction(AddressManager addressesManager) {
        return new PlatformSetAddressAction(addressesManager);
    }

    @Bean
    public AddAddressTagsAction addAddressTagsAction(AddressManager addressesManager) {
        return new AddAddressTagsAction(addressesManager);
    }

    @Bean
    public RemoveAddressTagsAction removeAddressTagsAction(AddressManager addressesManager) {
        return new RemoveAddressTagsAction(addressesManager);
    }

    @Bean
    public TouchAddressAction touchAddressAction(AddressManager addressesManager) {
        return new TouchAddressAction(addressesManager);
    }

    @Bean
    public PatchAddressAction patchAddressAction(AddressManager addressesManager) {
        return new PatchAddressAction(addressesManager);
    }

    @Bean
    public DeleteAddressAction deleteAddressAction(AddressManager addressesManager) {
        return new DeleteAddressAction(addressesManager);
    }
}
