package ru.yandex.chemodan.app.dataapi.web.profile.addresses;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestListParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "remove-address-tags", namespace = NS.PROFILE),
        description = "Удалить тэги")
@Path(value = "/addresses/{addressId}/untag", methods = HttpMethod.PUT)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class RemoveAddressTagsAction extends AddressActionBase {

    @PathParam
    private String addressId;
    @RequestListParam(value = "tag")
    private ListF<String> tags;

    public RemoveAddressTagsAction(AddressManager addressesManager) {
        super(addressesManager);
    }

    @Override
    public OkPojo execute() throws Exception {
        addressManager.removeTags(user, addressId, tags);
        return new OkPojo();
    }
}
