package ru.yandex.chemodan.app.dataapi.web.profile.addresses;

import lombok.Setter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.Address;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "set-address", namespace = NS.PROFILE),
        description = "Изменить адрес")
@Path(value = "/addresses/{addressId}", methods = HttpMethod.PUT)
@Path(value = "/platform/v2/personality/profile/addresses/{addressId}", methods = HttpMethod.PUT)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
@Setter
public class SetAddressAction extends AddressActionBase {

    @PathParam
    private String addressId;
    @BindWith(value = BenderJsonParameterBinder.class)
    private Address rawAddress;

    public SetAddressAction(AddressManager addressesManager) {
        super(addressesManager);
    }

    @Override
    public Address execute() throws Exception {
        //we should ignore possible addressId in json data
        rawAddress.setAddressId(Option.of(addressId));
        return addressManager.putAddressIgnoringMinedAttributes(user, rawAddress);
    }
}
