package ru.yandex.chemodan.app.dataapi.web.profile.addresses;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
    value = @Action.Alias(value = "touch-address", namespace = NS.PROFILE),
    description = "Обновить дату последнего использования адреса")
@Path(value = "/addresses/{addressId}/touch", methods = HttpMethod.PUT)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class TouchAddressAction extends AddressActionBase {

    @PathParam
    private String addressId;

    public TouchAddressAction(AddressManager addressesManager) {
        super(addressesManager);
    }


    @Override
    public OkPojo execute() throws Exception {
        addressManager.touchAddress(user, addressId);
        return new OkPojo();
    }
}
