package ru.yandex.chemodan.app.dataapi.web.profile.events;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.ProfileFlightsManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;

/**
 * @author tolmalev
 */
@Configuration
public class EventsActionsContextConfiguration {

    @Bean
    public FlightActionsContainer flightActionsContainer(ProfileFlightsManager flightsManager) {
        return new FlightActionsContainer(flightsManager);
    }

    @Bean
    public GetActualFlightsAction getActualFlightsAction(CachedFullProfileManager profileManager) {
        return new GetActualFlightsAction(profileManager);
    }

    @Bean
    public GetActualFlightAction getActualFlightAction(CachedFullProfileManager profileManager) {
        return new GetActualFlightAction(profileManager);
    }
}
