package ru.yandex.chemodan.app.dataapi.web.profile.events;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.Flight;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.ProfileFlightsManager;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiUserIdBinder;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;

/**
 * @author tolmalev
 */
@ActionContainer
public class FlightActionsContainer {

    protected final ProfileFlightsManager flightsManager;

    public FlightActionsContainer(ProfileFlightsManager flightsManager) {
        this.flightsManager = flightsManager;
    }

    @Action(
            value = @Action.Alias(value = "save-flight", namespace = NS.PROFILE),
            description = "Сохранить перелет пользователя")
    @Path(value = "/events/flights/actual/{eventId}", methods = HttpMethod.PUT)
    @Path(value = "/platform/personality/profile/events/flights/actual/{eventId}", methods = HttpMethod.PUT)
    public Flight saveFlight(
            @BindWith(DataApiUserIdBinder.class)
            DataApiUserId user,
            @PathParam("eventId")
            String eventId,
            @BindWith(value = BenderJsonParameterBinder.class)
            Flight flight)
    {
        return flightsManager.saveFlight(user, eventId, flight);
    }

    @Action(
            value = @Action.Alias(value = "create-flight", namespace = NS.PROFILE),
            description = "Создать перелет пользователя")
    @Path(value = "/events/flights/actual/", methods = HttpMethod.POST)
    @Path(value = "/platform/personality/profile/events/flights/actual/", methods = HttpMethod.POST)
    public Flight createFlight(
            @BindWith(DataApiUserIdBinder.class)
            DataApiUserId user,
            @BindWith(value = BenderJsonParameterBinder.class)
            Flight flight)
    {
        return flightsManager.createFlight(user, flight);
    }

    @Action(
            value = @Action.Alias(value = "delete-flight", namespace = NS.PROFILE),
            description = "Удалить перелет")
    @Path(value = "/events/flights/actual/{eventId}", methods = HttpMethod.DELETE)
    @Path(value = "/platform/personality/profile/events/flights/actual/{eventId}", methods = HttpMethod.DELETE)
    public OkPojo deleteFlight(
            @BindWith(DataApiUserIdBinder.class)
            DataApiUserId user,
            @PathParam("eventId")
            String eventId)
    {
        flightsManager.deleteEntity(user, eventId);
        return new OkPojo();
    }
}
