package ru.yandex.chemodan.app.dataapi.web.profile.events;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.Flight;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "get-actual-flight", namespace = NS.PROFILE),
        description = "Получить один перелет пользователя")
@Path("/events/flights/actual/{flightId}")
@Path("/platform/personality/profile/events/flights/actual/{flightId}")
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetActualFlightAction extends GetProfilePartActionSupport<Flight> {

    @PathParam
    private String flightId;

    public GetActualFlightAction(CachedFullProfileManager profileManager) {
        super(profileManager, true);
    }

    @Override
    public Flight getFromFullProfile(FullUserProfile profile) {
        return profile.events.flights
                .find(f -> f.uniqueFlightId.isSome(flightId))
                .getOrThrow(NotFoundException.consF("Flight not found"));
    }
}
