package ru.yandex.chemodan.app.dataapi.web.profile.events;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.Flight;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "get-actual-flights-list", namespace = NS.PROFILE),
        description = "Получить список актуальных перелетов пользователя")
@Path("/events/flights/actual")
@Path("/platform/personality/profile/events/flights/actual")
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetActualFlightsAction extends GetProfilePartActionSupport<GetActualFlightsAction.ActualFlightsList> {

    public GetActualFlightsAction(CachedFullProfileManager profileManager) {
        super(profileManager);
    }

    @Override
    public ActualFlightsList getFromFullProfile(FullUserProfile profile) {
        return new ActualFlightsList(profile.events.flights);
    }

    @ActionResultPojo
    @BenderBindAllFields
    static final class ActualFlightsList extends DefaultObject {
        public final ListF<Flight> items;

        private ActualFlightsList(ListF<Flight> items) {
            this.items = items;
        }
    }
}
