package ru.yandex.chemodan.app.dataapi.web.profile.geopoint;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.geopoint.GeoPointsManager;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author akirakozov
 */
@Action(
        value = @Action.Alias(value = "delete-geopoint", namespace = NS.PROFILE),
        description = "Удалить гео-точку пользователя")
@Path(value = "/geopoints/{geoPointId}", methods = HttpMethod.DELETE)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class DeleteGeoPointAction extends GeoPointActionBase {

    @PathParam
    private String geoPointId;

    public DeleteGeoPointAction(GeoPointsManager geoPointsManager) {
        super(geoPointsManager);
    }

    @Override
    public OkPojo execute() throws Exception {
        geoPointsManager.deleteEntity(user, geoPointId);
        return new OkPojo();
    }
}
