package ru.yandex.chemodan.app.dataapi.web.profile.geopoint;

import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.apps.profile.geopoint.GeoPoint;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author akirakozov
 */
@Action(
        value = @Action.Alias(value = "get-geopoint", namespace = NS.PROFILE),
        description = "Получить одну гео-точку пользователя")
@Path("/geopoints/{geoPointId}")
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetGeoPointAction extends GetProfilePartActionSupport<GeoPoint> {

    @PathParam
    private String geoPointId;

    public GetGeoPointAction(CachedFullProfileManager profileManager) {
        super(profileManager, true);
    }

    @Override
    public GeoPoint getFromFullProfile(FullUserProfile profile) {
        return profile.geoPoints.geoPoints
                .filter(address -> address.getGeoPointId().isSome(geoPointId))
                .firstO()
                .getOrThrow(NotFoundException.consF("Geo-point not found: " + geoPointId));
    }
}
