package ru.yandex.chemodan.app.dataapi.web.profile.geopoint;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.chemodan.app.dataapi.apps.profile.geopoint.GeoPoint;
import ru.yandex.chemodan.app.dataapi.web.profile.GetProfilePartActionSupport;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author akirakozov
 */
@Action(
        value = @Action.Alias(value = "get-geopoints", namespace = NS.PROFILE),
        description = "Получить список гео-точек пользователя")
@Path("/geopoints")
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetGeoPointsAction extends GetProfilePartActionSupport<GetGeoPointsAction.ListGeoPointPojo> {
    public GetGeoPointsAction(CachedFullProfileManager profileManager) {
        super(profileManager);
    }

    @Override
    public ListGeoPointPojo getFromFullProfile(FullUserProfile profile) {
        return new ListGeoPointPojo(profile.geoPoints.geoPoints);
    }

    @BenderBindAllFields
    @ActionResultPojo
    public static final class ListGeoPointPojo {
        public final ListF<GeoPoint> items;

        private ListGeoPointPojo(ListF<GeoPoint> items) {
            this.items = items;
        }
    }
}
