package ru.yandex.chemodan.app.dataapi.web.profile.geopoint;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.apps.profile.full.CachedFullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.geopoint.GeoPointsManager;

/**
 * @author akirakozov
 */
@Configuration
public class ProfileGeoPointActionsContextConfiguration {

    @Bean
    public SaveGeoPointAction createGeoPointAction(GeoPointsManager geoPointsManager) {
        return new SaveGeoPointAction(geoPointsManager);
    }

    @Bean
    public DeleteGeoPointAction deleteGeoPointAction(GeoPointsManager geoPointsManager) {
        return new DeleteGeoPointAction(geoPointsManager);
    }

    @Bean
    public GetGeoPointAction getGeoPointAction(CachedFullProfileManager fullProfileManager) {
        return new GetGeoPointAction(fullProfileManager);
    }

    @Bean
    public GetGeoPointsAction getGeoPointsAction(CachedFullProfileManager fullProfileManager) {
        return new GetGeoPointsAction(fullProfileManager);
    }
}
