package ru.yandex.chemodan.app.dataapi.web.profile.geopoint;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.apps.profile.geopoint.GeoPoint;
import ru.yandex.chemodan.app.dataapi.apps.profile.geopoint.GeoPointsManager;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.intercept.InterceptWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author akirakozov
 */
@Action(
        value = @Action.Alias(value = "post-geopoints", namespace = NS.PROFILE),
        description = "Создать гео-точку")
@Path(value = "/geopoints/{geopointId}", methods = HttpMethod.PUT)
@InterceptWith(value = ProxyInterceptor.class)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class SaveGeoPointAction extends GeoPointActionBase {

    @PathParam
    private String geopointId;

    @BindWith(value = BenderJsonParameterBinder.class)
    private GeoPoint rawGeoPoint;

    public SaveGeoPointAction(GeoPointsManager geoPointsManager) {
        super(geoPointsManager);
    }

    @Override
    public GeoPoint execute() throws Exception {
        // override id from json
        rawGeoPoint.setGeoPointId(Option.of(geopointId));
        return geoPointsManager.saveGeoPoint(user, rawGeoPoint);
    }
}
